/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atom_particleinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom_particleinfo.hpp"

#include <iostream>

/** Constructor of ParticleInfo.
 */
ParticleInfo::ParticleInfo() :
  nr(-1),
  name("Unknown")
{};

ParticleInfo::ParticleInfo(ParticleInfo *pointer) :
  nr(pointer->nr),
  name(pointer->name)
{}


/** Destructor of ParticleInfo.
 */
ParticleInfo::~ParticleInfo()
{};

const string& ParticleInfo::getName() const{
  return name;
}

void ParticleInfo::setName(const string& _name){
  name = _name;
}

ostream & operator << (ostream &ost, const ParticleInfo &a)
{
  ost << a.getName();
  return ost;
};

ostream & ParticleInfo::operator << (ostream &ost) const
{
  ost << getName();
  return ost;
};

