/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atom_graphnodeinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom_graphnodeinfo.hpp"

/** Constructor of class GraphNodeInfo.
 */
GraphNodeInfo::GraphNodeInfo() :
  GraphNr(-1),
  ComponentNr(0),
  LowpointNr(-1),
  SeparationVertex(false),
  IsCyclic(false),
  Ancestor(0)
{};

/** Destructor of class GraphNodeInfo.
 */
GraphNodeInfo::~GraphNodeInfo()
{
  delete[](ComponentNr);
};
