/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atom_graphnode.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "atom_graphnode.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

/** Constructor of class GraphNode.
 */
GraphNode::GraphNode()
{
};

/** Destructor of class GraphNode.
 */
GraphNode::~GraphNode()
{
};

/** Output graph info of this atom.
 * \param *out output stream
 */
void GraphNode::OutputGraphInfo() const
{
  DoLog(2) && (Log() << Verbose(2) << "Atom " << getName() << " is " << ((SeparationVertex) ? "a" : "not a") << " separation vertex, components are " << *this);
  DoLog(3) && (Log() << Verbose(3) << " with Lowpoint " << LowpointNr << " and Graph Nr. " << GraphNr << "." << endl);
};

/** Output a list of flags, stating whether the bond was visited or not.
 * Note, we make use of the last entry of the ComponentNr always being -1 if allocated.
 * \param *out output stream for debugging
 */
void GraphNode::OutputComponentNumber(ostream *out) const
{
  *out << *this;
};

ostream &operator<<(ostream &out, const GraphNode &a)
{
  if (a.ComponentNr != NULL) {
    for (int i=0; a.ComponentNr[i] != -1; i++)
      out << a.ComponentNr[i];
  }
  return out;
}
