/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <utility>
#include "Patterns/Singleton_impl.hpp"
#include "UIElements/UIFactory.hpp"
#include "Helpers/Assert.hpp"
#include "Helpers/MemDebug.hpp"

using namespace std;

std::map<std::string,boost::shared_ptr<UIFactory::factoryDescription> > UIFactory::factories;

UIFactory::UIFactory()
{}

UIFactory::~UIFactory()
{}

void UIFactory::makeUserInterface(std::string type) {
  ASSERT(factories.count(type),"Selected factory was not registered before creation.");
  // call the factory factory
  setInstance(factories[type]->makeFactory());
}

void UIFactory::registerFactory(factoryDescription *factoryDesc) {
  ASSERT(!factories.count(factoryDesc->name),"Trying to re-register an already registered factory.");
  factories.insert(make_pair(factoryDesc->name,
                             boost::shared_ptr<factoryDescription>(factoryDesc)));
}

CONSTRUCT_SINGLETON(UIFactory)

UIFactory::factoryDescription::factoryDescription(string _name) :
  name(_name)
{}

UIFactory::factoryDescription::~factoryDescription()
{}
