/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QTUIFactory.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cassert>

#include <qapplication.h>


#include "UIElements/QT4/QTUIFactory.hpp"
#include "UIElements/QT4/QTMainWindow.hpp"
#include "UIElements/QT4/QTDialog.hpp"

#include "Helpers/MemDebug.hpp"

#include "version.h"
#include "defs.hpp"

using namespace std;

QTUIFactory::QTUIFactory() :
  argc(1)
{
  // For now we just fake the command line parameters to make QT happy
  argv = new char*[1];
  argv[0] = new char[256];
  strcpy(argv[0],MOLECUILDERVERSION);
  app = new QApplication(argc,argv);
}

QTUIFactory::~QTUIFactory()
{
  delete app;
  delete [] argv[0];
  delete [] argv;
}

Dialog* QTUIFactory::makeDialog() {
  return new QTDialog();
}

MainWindow* QTUIFactory::makeMainWindow() {
  return new QTMainWindow(app);
}

QTUIFactory::description::description() :
    UIFactory::factoryDescription("QT4")
{}

QTUIFactory::description::~description()
{}

UIFactory* QTUIFactory::description::makeFactory(){
  return new QTUIFactory();
}
