/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ThermoStatContainer.cpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <cstring>

#include "ConfigFileBuffer.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "ThermoStatContainer.hpp"
#include "Helpers/Verbose.hpp"

/** Constructor for class ThermoStatContainer.
 *
 */
ThermoStatContainer::ThermoStatContainer() :
  Thermostat(4),
  ThermostatImplemented(NULL),
  ThermostatNames(NULL),
  TempFrequency(2.5),
  alpha(0.),
  HooverMass(0.),
  TargetTemp(0.00095004455),
  ScaleTempStep(25)
{
  ThermostatImplemented = new int[MaxThermostats];
  ThermostatNames = new char *[MaxThermostats];
  for (int j=0;j<MaxThermostats;j++)
    ThermostatNames[j] = new char[12];

  strcpy(ThermostatNames[0],"None");
  ThermostatImplemented[0] = 1;
  strcpy(ThermostatNames[1],"Woodcock");
  ThermostatImplemented[1] = 1;
  strcpy(ThermostatNames[2],"Gaussian");
  ThermostatImplemented[2] = 1;
  strcpy(ThermostatNames[3],"Langevin");
  ThermostatImplemented[3] = 1;
  strcpy(ThermostatNames[4],"Berendsen");
  ThermostatImplemented[4] = 1;
  strcpy(ThermostatNames[5],"NoseHoover");
  ThermostatImplemented[5] = 1;
}

/** Destructor for Class ThermoStatContainer.
 *
 */
ThermoStatContainer::~ThermoStatContainer()
{
  delete[](ThermostatImplemented);
  for (int j=0;j<MaxThermostats;j++)
    delete[](ThermostatNames[j]);
  delete[](ThermostatNames);
}


