/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TesselPoint.cpp
 *
 *  Created on: Jul 30, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "TesselPoint.hpp"

#include <iostream>


/** Constructor of class TesselPoint.
 */
TesselPoint::TesselPoint()
{};

/** Destructor for class TesselPoint.
 */
TesselPoint::~TesselPoint()
{};

std::ostream & TesselPoint::operator << (std::ostream &ost) const
{
  ParticleInfo::operator<<(ost);
  ost << "," << getPosition();
  return ost;
}

std::ostream & operator << (std::ostream &ost, const TesselPoint &a)
{
  a.ParticleInfo::operator<<(ost);
  ost << "," << a.getPosition();
  return ost;
}

