/*
 * Shape.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPE_HPP_
#define SHAPE_HPP_

#include <boost/shared_ptr.hpp>

#include <vector>

class Vector;
class Shape_impl;

class Shape
{
public:
  typedef boost::shared_ptr<Shape_impl> impl_ptr;
  friend impl_ptr getShapeImpl(const Shape&);

  Shape(impl_ptr);
  Shape(const Shape&);
  virtual ~Shape();

  bool isInside(const Vector &point) const;
  std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;

  Shape &operator=(const Shape& rhs);

protected:
  impl_ptr getImpl() const;

private:
  impl_ptr impl;
};

Shape Everywhere();
Shape Nowhere();

Shape operator&&(const Shape&,const Shape&);
Shape operator||(const Shape&,const Shape&);
Shape operator!(const Shape&);

#endif /* SHAPE_HPP_ */
