/*
 * PdbParser.hpp
 *
 *  Created on: Aug 17, 2010
 *      Author: heber
 */

#ifndef PDBPARSER_HPP_
#define PDBPARSER_HPP_

#include <string>
#include "Parser/FormatParser.hpp"

/**
 * Known keys for the Pdb line.
 */
class PdbKey {
public:
  enum PdbDataKey {
    noKey,
    x,
    Id,
    Type,
    extType,
    name,
    resName,
    chainID,
    resSeq,
    occupancy,
    tempFactor,
    segID,
    charge
  };
};

/**
 * Holds tremolo-specific information which is not store in the atom class.
 */
class PdbAtomInfoContainer {
public:
  PdbAtomInfoContainer();
  void set(PdbKey::PdbDataKey key, std::string value);
  std::string get(PdbKey::PdbDataKey key);
  std::string name;
  std::string extType;
  std::string resName;
  std::string chainID;
  std::string resSeq;
  std::string occupancy;
  std::string tempFactor;
  std::string segID;
  std::string charge;
};

/**
 * Loads a tremolo file into the World and saves the World as a tremolo file.
 */
class PdbParser : public FormatParser
{
public:
  PdbParser();
  ~PdbParser();
  void load(std::istream* file);
  void save(std::ostream* file);


private:
  void readAtomDataLine(string line);
  void parseAtomDataKeysLine(string line, int offset);
  void readNeighbors(std::stringstream* line, int numberOfNeighbors, int atomId);
  void processNeighborInformation();
  void adaptImprData();
  void adaptTorsion();
  std::string adaptIdDependentDataString(std::string data);
  bool isUsedField(std::string fieldName);
  void writeNeighbors(std::ostream* file, int numberOfNeighbors, atom* currentAtom);
  void saveLine(ostream* file, const atom* currentAtom, const char *name, const int AtomNo, const int ResdueNo);
  int getAtomId(int atomid) const;
  void setAtomId(int localatomid, int atomid);

  /**
   * Map to associate the known keys with numbers.
   */
  std::map<std::string, PdbKey::PdbDataKey> knownKeys;

  /**
   * Data which is currently not stored in atoms but was provided by the input
   * file.
   */
  std::map<int, PdbAtomInfoContainer> additionalAtomData;

  /**
   * Default additional atom data.
   */
  PdbAtomInfoContainer defaultAdditionalData;

  /**
   * Maps original atom IDs received from the parsed file to atom IDs in the
   * world.
   */
  std::map<int, int> atomIdMap;
};

#endif /* PDBPARSER_HPP_ */
