/*
 * BoxVector.cpp
 *
 *  Created on: Aug 26, 2010
 *      Author: heber
 */

#include <iostream>

#include "LinearAlgebra/BoxVector.hpp"
#include "LinearAlgebra/Vector.hpp"

BoxVector::BoxVector()
{}

BoxVector::~BoxVector()
{}

/** Factors given vector \a a times \a m.
 * \param a vector
 * \param m factor
 * \return m * a
 */
BoxVector const operator*(const BoxVector& a, const double m)
{
  BoxVector x(a);
  x.Scale(m);
  return x;
};

/** Factors given vector \a a times \a m.
 * \param m factor
 * \param a vector
 * \return m * a
 */
BoxVector const operator*(const double m, const BoxVector& a )
{
  BoxVector x(a);
  x.Scale(m);
  return x;
};

ostream& operator<<(ostream& ost, const BoxVector& m)
{
  ost << "(";
  for (int i=0;i<NDIM;i++) {
    ost << m[i];
    if (i != 2)
      ost << ",";
  }
  ost << ")";
  return ost;
};
