/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * log.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/logger.hpp"
#include "Helpers/errorlogger.hpp"

/**
 * Sets verbosity for the error logger and the standard logger.
 *
 * \param int verbosity level
 */
void setVerbosity(int verbosityLevel) {
  logger::getInstance().setVerbosity(verbosityLevel);
}

/**
 * Gets verbosity for the error logger and the standard logger.
 *
 * \param int verbosity level
 */
int getVerbosity() {
  return logger::getInstance().getVerbosity();
}

/**
 * Prints a log entry.
 *
 * \param indentation level of the message to log
 */
class logger& Log() {
  return logger::getInstance();
}

/** Checks verbosity for logger.
 * Is supposed to be used in construct as this:
 * DoLog(2) && (Log() << Verbose(2) << "message." << endl);
 * If DoLog does not return true, the right-hand side is not evaluated and we save some time.
 * \param verbose verbosity level of this message
 * \return true - print, false - don't
 */
bool DoLog(int verbose) {
  return (verbose <= logger::getInstance().verbosity);
}

/** Checks verbosity for errorlogger.
 * Is supposed to be used in construct as this:
 * DoLog(2) && (Log() << Verbose(2) << "message." << endl);
 * If DoLog does not return true, the right-hand side is not evaluated and we save some time.
 * \param verbose verbosity level of this message
 * \return true - print, false - don't
 */
bool DoeLog(int verbose) {
  return (verbose <= errorLogger::getInstance().verbosity);
}

/**
 * Prints an error log entry.
 *
 * \param indentation level of the message to log
 */
class errorLogger & eLog() {
  return errorLogger::getInstance();
}
