/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Info.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Info.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

int Info::verbosity = 0;

/**
 * Constructor. Do not use this function. Use getInstance() instead.
 *
 * \return Info instance
 */
Info::Info(const char *msg) :
  FunctionName(msg)
{
  verbosity++;
  DoLog(0) && (Log() << Verbose(0) << "Begin of " << FunctionName << endl);
};

/**
 * Destructor. Better use purgeInstance().
 */
Info::~Info() {
  DoLog(0) && (Log() << Verbose(0) << "End of " << FunctionName << endl);
  verbosity--;
}

/**
 * Sets the verbosity.
 *
 * \param verbosityLevel verbosity
 */
void Info::setVerbosity(int verbosityLevel) {
  verbosity = verbosityLevel;
}
