/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CustomException.cpp
 *
 *  Created on: Apr 7, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "CustomException.hpp"
#include <iostream>

using namespace std;

CustomException::CustomException(std::string _file, int _line):
 file(_file),
 line(_line)
{}

CustomException::~CustomException() throw ()
{}


ostream& operator<<(ostream &ost,CustomException &excp){
  // we use this to let others know from where the exception was thrown
  ost << excp.what() << "\nIn " << excp.file << ":" << excp.line;
  return ost;
}
