/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomTypeDescriptor_impl.cpp
 *
 *  Created on: Feb 25, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Descriptors/AtomTypeDescriptor_impl.hpp"

#include "atom.hpp"
#include "World.hpp"
#include "periodentafel.hpp"

AtomTypeDescriptor_impl::AtomTypeDescriptor_impl(const element* _type) :
  type(_type)
{}

AtomTypeDescriptor_impl::~AtomTypeDescriptor_impl()
{}

bool AtomTypeDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom) {
  return (atom.second->getType()==type);
}

AtomDescriptor AtomByType(const element *elem){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomTypeDescriptor_impl(elem)));
}

AtomDescriptor AtomByType(int Z){
  const element * elem = World::getInstance().getPeriode()->FindElement(Z);
  return AtomByType(elem);
}
