/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomicInfo.cpp
 *
 *  Created on: Aug 10, 2010
 *      Author: heber
 */

#include "atom.hpp"
#include "AtomicInfo.hpp"
#include "element.hpp"
#include "LinearAlgebra/Vector.hpp"

/********************************** Functions for class AtomicInfo **********************************/

AtomicInfo::AtomicInfo() :
    Type(NULL),
    Father(NULL),
    Id(-1)
{}
AtomicInfo::AtomicInfo(const atom &_atom) :
    Position(_atom.getPosition()),
    Type(_atom.getType()),
    Velocity(_atom.AtomicVelocity),
    Father(_atom.father),
    Mol(_atom.getMolecule()),
    Id(_atom.getId())
{}

AtomicInfo::~AtomicInfo()
{}


bool AtomicInfo::setAtom(atom &_atom) const
{
  _atom.setPosition(Position);
  _atom.setType(Type);
  _atom.father = const_cast<atom *>(Father); // TODO: Actually, atom::father should be const atom *!
  _atom.setMolecule(const_cast<molecule *>(Mol)); // this is ok, mol is const within AtomicInfo, but not outside (atoms need to register)
  _atom.AtomicVelocity = Velocity;
  if (_atom.getId() == Id)
    return true;
  else
    return (_atom.changeId(Id));
}

atomId_t AtomicInfo::getId() const {
  return Id;
}

AtomicInfo& AtomicInfo::operator=(const AtomicInfo& AI)
{
  if (&AI == this)  // check self-assignment
    return *this;
  Position = AI.Position;
  Type = AI.Type;
  Father = AI.Father;
  Mol = AI.Mol;
  Velocity = AI.Velocity;
  Id = AI.Id;
  return *this;
}

