/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetGaussianBasisAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "config.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/SetGaussianBasisAction.hpp"

// and construct the stuff
#include "SetGaussianBasisAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldSetGaussianBasisAction::performCall() {
  config *configuration = World::getInstance().getConfig();

  string lastname = configuration->basis;
  // obtain information
  getParametersfromValueStorage();
  configuration->basis = params.newname;

  DoLog(1) && (Log() << Verbose(1) << "Setting MPQC basis to " << configuration->basis << "." << endl);
  return Action::state_ptr(new WorldSetGaussianBasisState(lastname, params));
}

Action::state_ptr WorldSetGaussianBasisAction::performUndo(Action::state_ptr _state) {
  WorldSetGaussianBasisState *state = assert_cast<WorldSetGaussianBasisState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->basis = state->lastname;

  return Action::state_ptr(_state);
}

Action::state_ptr WorldSetGaussianBasisAction::performRedo(Action::state_ptr _state){
  WorldSetGaussianBasisState *state = assert_cast<WorldSetGaussianBasisState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->basis = state->params.newname;

  return Action::state_ptr(_state);
}

bool WorldSetGaussianBasisAction::canUndo() {
  return true;
}

bool WorldSetGaussianBasisAction::shouldUndo() {
  return true;
}

const string WorldSetGaussianBasisAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
