/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetDefaultNameAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/SetDefaultNameAction.hpp"

// and construct the stuff
#include "SetDefaultNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldSetDefaultNameAction::performCall() {
  string Worldsdefaultname;
  Worldsdefaultname = World::getInstance().getDefaultName();
  WorldSetDefaultNameState *UndoState = new WorldSetDefaultNameState(Worldsdefaultname, params);

  // obtain information
  getParametersfromValueStorage();

  World::getInstance().setDefaultName(params.newname);
  DoLog(0) && (Log() << Verbose(0) << "Default name of new molecules set to " << World::getInstance().getDefaultName() << "." << endl);
  return Action::state_ptr(UndoState);
}

Action::state_ptr WorldSetDefaultNameAction::performUndo(Action::state_ptr _state) {
  WorldSetDefaultNameState *state = assert_cast<WorldSetDefaultNameState*>(_state.get());

  World::getInstance().setDefaultName(state->lastname);
  DoLog(0) && (Log() << Verbose(0) << "Default name of new molecules set to " << World::getInstance().getDefaultName() << "." << endl);

  return Action::state_ptr(_state);
}

Action::state_ptr WorldSetDefaultNameAction::performRedo(Action::state_ptr _state){
  WorldSetDefaultNameState *state = assert_cast<WorldSetDefaultNameState*>(_state.get());

  World::getInstance().setDefaultName(state->params.newname);
  DoLog(0) && (Log() << Verbose(0) << "Default name of new molecules set to " << World::getInstance().getDefaultName() << "." << endl);

  return Action::state_ptr(_state);
}

bool WorldSetDefaultNameAction::canUndo() {
  return true;
}

bool WorldSetDefaultNameAction::shouldUndo() {
  return true;
}

const string WorldSetDefaultNameAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
