/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * OutputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Parser/ChangeTracker.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/OutputAction.hpp"

// and construct the stuff
#include "OutputAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldOutputAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(0) && (Log() << Verbose(0) << "Saving world to files." << endl);
  ChangeTracker::getInstance().saveStatus();
  return Action::success;
}

Action::state_ptr WorldOutputAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldOutputAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldOutputAction::canUndo() {
  return false;
}

bool WorldOutputAction::shouldUndo() {
  return false;
}

const string WorldOutputAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
