/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ChangeBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"
#include "Box.hpp"
#include "LinearAlgebra/Matrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/ChangeBoxAction.hpp"

// and construct the stuff
#include "ChangeBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldChangeBoxAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  World::getInstance().setDomain(params.cell_size.getM()); // this is needed as only this function is OBSERVEd.

  DoLog(0) && (Log() << Verbose(0) << "Setting box domain to " << World::getInstance().getDomain().getM() << endl);
  return Action::success;
}

Action::state_ptr WorldChangeBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldChangeBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldChangeBoxAction::canUndo() {
  return false;
}

bool WorldChangeBoxAction::shouldUndo() {
  return false;
}

const string WorldChangeBoxAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
