/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CenterOnEdgeAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"
#include "LinearAlgebra/Matrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/CenterOnEdgeAction.hpp"

// and construct the stuff
#include "CenterOnEdgeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldCenterOnEdgeAction::performCall() {
  Vector Min;
  Vector Max;

  // obtain information
  getParametersfromValueStorage();

  // get maximum and minimum
  vector<atom *> AllAtoms = World::getInstance().getAllAtoms();
  ASSERT(AllAtoms.size() > 0, "For CenteronEdge atoms must be present.");
  vector<atom *>::iterator AtomRunner = AllAtoms.begin();
  Min = (*AtomRunner)->getPosition();
  Max = (*AtomRunner)->getPosition();
  for (; AtomRunner != AllAtoms.end(); ++AtomRunner) {
    for (int i=0;i<NDIM;i++) {
      if ((*AtomRunner)->at(i) > Max[i])
        Max[i] = (*AtomRunner)->at(i);
      if ((*AtomRunner)->at(i) < Min[i])
        Min[i] = (*AtomRunner)->at(i);
    }
  }
  // set new box size
  Matrix domain;
  for (int i=0;i<NDIM;i++) {
    double tmp = Max[i]-Min[i];
    tmp = fabs(tmp)>=1. ? tmp : 1.0;
    domain.at(i,i) = tmp;
  }
  World::getInstance().setDomain(domain);
  // translate all atoms, such that Min is aty (0,0,0)
  for (vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner)
    *(*AtomRunner) -= Min;

  return Action::success;
}

Action::state_ptr WorldCenterOnEdgeAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldCenterOnEdgeAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldCenterOnEdgeAction::canUndo() {
  return false;
}

bool WorldCenterOnEdgeAction::shouldUndo() {
  return false;
}

const string WorldCenterOnEdgeAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
