/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoundInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>
#include <vector>

using namespace std;

#include "Actions/WorldAction/BoundInBoxAction.hpp"

// and construct the stuff
#include "BoundInBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldBoundInBoxAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // center
  vector<molecule*> AllMolecules = World::getInstance().getAllMolecules();
  for (vector<molecule*>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
    (*MolRunner)->BoundInBox();
  }
  return Action::success;
}

Action::state_ptr WorldBoundInBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldBoundInBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldBoundInBoxAction::canUndo() {
  return false;
}

bool WorldBoundInBoxAction::shouldUndo() {
  return false;
}

const string WorldBoundInBoxAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
