/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ValueStorage.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "ValueStorage.hpp"
#include "Patterns/Singleton_impl.hpp"

ValueStorage::ValueStorage() :
  MapOfActions_instance(MapOfActions::getInstance())
{};

ValueStorage::~ValueStorage() {};

std::string ValueStorage::getDescription(std::string actionname) {
  return MapOfActions::getInstance().getDescription(actionname);
}

CONSTRUCT_SINGLETON(ValueStorage)
