/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NonConvexEnvelopeAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "boundary.hpp"
#include "linkedcell.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "tesselation.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/TesselationAction/NonConvexEnvelopeAction.hpp"

// and construct the stuff
#include "NonConvexEnvelopeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr TesselationNonConvexEnvelopeAction::performCall() {
  molecule * Boundary = NULL;
  bool Success = false;
  clock_t start,end;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    Boundary = iter->second;
    class Tesselation *T = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating non-convex envelope of molecule." << Boundary->getId() << endl);
    DoLog(1) && (Log() << Verbose(1) << "Using rolling ball of radius " << params.SphereRadius << " and storing tecplot data in " << params.filename << "." << endl);
    DoLog(1) && (Log() << Verbose(1) << "Specified molecule has " << Boundary->getAtomCount() << " atoms." << endl);
    start = clock();
    LCList = new LinkedCell(*Boundary, params.SphereRadius*2.);
    Success = FindNonConvexBorder(Boundary, T, LCList, params.SphereRadius, params.filename.c_str());
    //FindDistributionOfEllipsoids(T, &LCList, N, number, params.filename.c_str());
    end = clock();
    DoLog(0) && (Log() << Verbose(0) << "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s." << endl);
    delete(LCList);
    delete(T);
  }
  if (Success)
    return Action::success;
  else
    return Action::failure;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performUndo(Action::state_ptr _state) {
//  TesselationNonConvexEnvelopeState *state = assert_cast<TesselationNonConvexEnvelopeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool TesselationNonConvexEnvelopeAction::canUndo() {
  return false;
}

bool TesselationNonConvexEnvelopeAction::shouldUndo() {
  return false;
}

const string TesselationNonConvexEnvelopeAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
