/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ConvexEnvelopeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "boundary.hpp"
#include "config.hpp"
#include "linkedcell.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "tesselation.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/TesselationAction/ConvexEnvelopeAction.hpp"

// and construct the stuff
#include "ConvexEnvelopeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr TesselationConvexEnvelopeAction::performCall() {
  molecule * mol = NULL;
  bool Success = true;
  config *configuration = World::getInstance().getConfig();

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    class Tesselation *TesselStruct = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating volume of the convex envelope.");
    DoLog(1) && (Log() << Verbose(1) << "Storing tecplot convex data in " << params.filenameConvex << "." << endl);
    DoLog(1) && (Log() << Verbose(1) << "Storing tecplot non-convex data in " << params.filenameNonConvex << "." << endl);
    LCList = new LinkedCell(*mol, 100.);
    //Boundaries *BoundaryPoints = NULL;
    //FindConvexBorder(mol, BoundaryPoints, TesselStruct, LCList, argv[argptr]);
    // TODO: Beide Funktionen sollten streams anstelle des Filenamen benutzen, besser fuer unit tests
    FindNonConvexBorder(mol, TesselStruct, LCList, 50., params.filenameNonConvex.c_str());
    //RemoveAllBoundaryPoints(TesselStruct, mol, argv[argptr]);
    const double volumedifference = ConvexizeNonconvexEnvelope(TesselStruct, mol, params.filenameConvex.c_str());
    const double clustervolume = VolumeOfConvexEnvelope(TesselStruct, configuration);
    DoLog(0) && (Log() << Verbose(0) << "The tesselated volume area is " << clustervolume << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    DoLog(0) && (Log() << Verbose(0) << "The non-convex tesselated volume area is " << clustervolume-volumedifference << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    delete(TesselStruct);
    delete(LCList);
  }
  if (Success)
    return Action::success;
  else
    return Action::failure;
}

Action::state_ptr TesselationConvexEnvelopeAction::performUndo(Action::state_ptr _state) {
//  TesselationConvexEnvelopeState *state = assert_cast<TesselationConvexEnvelopeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr TesselationConvexEnvelopeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool TesselationConvexEnvelopeAction::canUndo() {
  return false;
}

bool TesselationConvexEnvelopeAction::shouldUndo() {
  return false;
}

const string TesselationConvexEnvelopeAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
