/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotMoleculeByFormulaAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeFormulaDescriptor.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/NotMoleculeByFormulaAction.hpp"

// and construct the stuff
#include "NotMoleculeByFormulaAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotMoleculeByFormulaAction::performCall() {
  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting molecules with chemical formula " << params.formula << ":" << endl);
  std::vector<molecule *> matchingMolecules = World::getInstance().getAllMolecules(MoleculeByFormula(params.formula));
  for (std::vector<molecule *>::const_iterator iter = matchingMolecules.begin(); iter != matchingMolecules.end(); ++iter) {
    DoLog(1) && (Log() << Verbose(1) << "\t" << (*iter)->getId() << ", " << (*iter)->getName() << "." << endl);
  }
  World::getInstance().unselectAllMolecules(MoleculeByFormula(params.formula));
  return Action::state_ptr(new SelectionNotMoleculeByFormulaState(selectedMolecules,params));
}

Action::state_ptr SelectionNotMoleculeByFormulaAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeByFormulaState *state = assert_cast<SelectionNotMoleculeByFormulaState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotMoleculeByFormulaAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeByFormulaState *state = assert_cast<SelectionNotMoleculeByFormulaState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeByFormula(state->params.formula));

  return Action::state_ptr(_state);
}

bool SelectionNotMoleculeByFormulaAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByFormulaAction::shouldUndo() {
  return true;
}

const string SelectionNotMoleculeByFormulaAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
