/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAtomByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/NotAtomByIdAction.hpp"

// and construct the stuff
#include "NotAtomByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAtomByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  if (World::getInstance().isSelected(params.Walker)) {
    DoLog(1) && (Log() << Verbose(1) << "Unselecting atom " << *params.Walker << endl);
    World::getInstance().unselectAtom(params.Walker);
    return Action::state_ptr(new SelectionNotAtomByIdState(params));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionNotAtomByIdAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByIdState *state = assert_cast<SelectionNotAtomByIdState*>(_state.get());

  if (state->params.Walker != NULL)
    World::getInstance().selectAtom(state->params.Walker);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByIdAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByIdState *state = assert_cast<SelectionNotAtomByIdState*>(_state.get());

  if (state->params.Walker != NULL)
    World::getInstance().unselectAtom(state->params.Walker);

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByIdAction::canUndo() {
  return true;
}

bool SelectionNotAtomByIdAction::shouldUndo() {
  return true;
}

const string SelectionNotAtomByIdAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
