/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomTypeDescriptor.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/NotAtomByElementAction.hpp"

// and construct the stuff
#include "NotAtomByElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAtomByElementAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting atoms of type " << *params.elemental << endl);
  World::getInstance().unselectAllAtoms(AtomByType(params.elemental));
  return Action::state_ptr(new SelectionNotAtomByElementState(selectedAtoms,params));
}

Action::state_ptr SelectionNotAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByType(state->params.elemental));

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByElementAction::canUndo() {
  return true;
}

bool SelectionNotAtomByElementAction::shouldUndo() {
  return true;
}

const string SelectionNotAtomByElementAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
