/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllAtomsOfMoleculeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/NotAllAtomsOfMoleculeAction.hpp"

// and construct the stuff
#include "NotAllAtomsOfMoleculeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms of molecule " << params.mol->getName() << "." << endl);
  World::getInstance().unselectAtomsOfMolecule(params.mol);
  return Action::state_ptr(new SelectionNotAllAtomsOfMoleculeState(selectedAtoms, params));
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsOfMoleculeState *state = assert_cast<SelectionNotAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsOfMoleculeState *state = assert_cast<SelectionNotAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().unselectAtomsOfMolecule(state->params.mol);

  return Action::state_ptr(_state);
}

bool SelectionNotAllAtomsOfMoleculeAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsOfMoleculeAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsOfMoleculeAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
