/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllAtomsInsideSphereAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomShapeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/NotAllAtomsInsideSphereAction.hpp"

// and construct the stuff
#include "NotAllAtomsInsideSphereAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms inside a sphere at " << params.position << " with radius " << params.radius << "." << endl);
  Shape s = translate(resize(Sphere(),params.radius),params.position);
  World::getInstance().unselectAllAtoms(AtomByShape(s));
  return Action::state_ptr(new SelectionNotAllAtomsInsideSphereState(selectedAtoms, params));
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsInsideSphereState *state = assert_cast<SelectionNotAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsInsideSphereState *state = assert_cast<SelectionNotAllAtomsInsideSphereState*>(_state.get());

  Shape s = translate(resize(Sphere(),state->params.radius),state->params.position);
  World::getInstance().unselectAllAtoms(AtomByShape(s));

  return Action::state_ptr(_state);
}

bool SelectionNotAllAtomsInsideSphereAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsInsideSphereAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsInsideSphereAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
