/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/NotAllAtomsAction.hpp"

// and construct the stuff
#include "NotAllAtomsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllAtomsAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms." << endl);
  World::getInstance().clearAtomSelection();
  return Action::state_ptr(new SelectionNotAllAtomsState(selectedAtoms, params));
}

Action::state_ptr SelectionNotAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsState *state = assert_cast<SelectionNotAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllAtomsAction::performRedo(Action::state_ptr _state){
  //SelectionNotAllAtomsState *state = assert_cast<SelectionNotAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();

  return Action::state_ptr(_state);
}

bool SelectionNotAllAtomsAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
