/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeOfAtomAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/MoleculeOfAtomAction.hpp"

// and construct the stuff
#include "MoleculeOfAtomAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionMoleculeOfAtomAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Selecting molecule to which " << params.Walker->getName() << " belongs." << endl);
  World::getInstance().selectMoleculeOfAtom(params.Walker);
  return Action::state_ptr(new SelectionMoleculeOfAtomState(selectedMolecules, params));
}

Action::state_ptr SelectionMoleculeOfAtomAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeOfAtomState *state = assert_cast<SelectionMoleculeOfAtomState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeOfAtomAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeOfAtomState *state = assert_cast<SelectionMoleculeOfAtomState*>(_state.get());

  World::getInstance().selectMoleculeOfAtom(state->params.Walker);

  return Action::state_ptr(_state);
}

bool SelectionMoleculeOfAtomAction::canUndo() {
  return true;
}

bool SelectionMoleculeOfAtomAction::shouldUndo() {
  return true;
}

const string SelectionMoleculeOfAtomAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
