/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/MoleculeByIdAction.hpp"

// and construct the stuff
#include "MoleculeByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionMoleculeByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  if (!World::getInstance().isSelected(params.mol)) {
    DoLog(1) && (Log() << Verbose(1) << "Selecting molecule " << params.mol->name << endl);
    World::getInstance().selectMolecule(params.mol);
    return Action::state_ptr(new SelectionMoleculeByIdState(params));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionMoleculeByIdAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByIdState *state = assert_cast<SelectionMoleculeByIdState*>(_state.get());

  if (state->params.mol != NULL)
    World::getInstance().unselectMolecule(state->params.mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByIdAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByIdState *state = assert_cast<SelectionMoleculeByIdState*>(_state.get());

  if (state->params.mol != NULL)
    World::getInstance().selectMolecule(state->params.mol);

  return Action::state_ptr(state);
}

bool SelectionMoleculeByIdAction::canUndo() {
  return true;
}

bool SelectionMoleculeByIdAction::shouldUndo() {
  return true;
}

const string SelectionMoleculeByIdAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
