/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByFormulaAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeFormulaDescriptor.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/MoleculeByFormulaAction.hpp"

// and construct the stuff
#include "MoleculeByFormulaAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionMoleculeByFormulaAction::performCall() {
  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting molecules with chemical formula " << params.formula << ":" << endl);
  std::vector<molecule *> matchingMolecules = World::getInstance().getAllMolecules(MoleculeByFormula(params.formula));
  for (std::vector<molecule *>::const_iterator iter = matchingMolecules.begin(); iter != matchingMolecules.end(); ++iter) {
    DoLog(1) && (Log() << Verbose(1) << "\t" << (*iter)->getId() << ", " << (*iter)->getName() << "." << endl);
  }
  World::getInstance().selectAllMolecules(MoleculeByFormula(params.formula));
  return Action::state_ptr(new SelectionMoleculeByFormulaState(selectedMolecules,params));
}

Action::state_ptr SelectionMoleculeByFormulaAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByFormulaState *state = assert_cast<SelectionMoleculeByFormulaState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByFormulaAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByFormulaState *state = assert_cast<SelectionMoleculeByFormulaState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeByFormula(state->params.formula));

  return Action::state_ptr(_state);
}

bool SelectionMoleculeByFormulaAction::canUndo() {
  return true;
}

bool SelectionMoleculeByFormulaAction::shouldUndo() {
  return true;
}

const string SelectionMoleculeByFormulaAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
