/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ClearAllMoleculesAction.cpp
 *
 *  Created on: Aug 09, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/ClearAllMoleculesAction.hpp"

// and construct the stuff
#include "ClearAllMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionClearAllMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Clearing molecule selection." << endl);
  World::getInstance().clearMoleculeSelection();
  return Action::state_ptr(new SelectionClearAllMoleculesState(selectedMolecules,params));
}

Action::state_ptr SelectionClearAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionClearAllMoleculesState *state = assert_cast<SelectionClearAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionClearAllMoleculesAction::performRedo(Action::state_ptr _state){
  //SelectionClearAllMoleculesState *state = assert_cast<SelectionClearAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();

  return Action::state_ptr(_state);
}

bool SelectionClearAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionClearAllMoleculesAction::shouldUndo() {
  return true;
}

const string SelectionClearAllMoleculesAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
