/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ClearAllAtomsAction.cpp
 *
 *  Created on: Aug 09, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/ClearAllAtomsAction.hpp"

// and construct the stuff
#include "ClearAllAtomsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionClearAllAtomsAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  DoLog(1) && (Log() << Verbose(1) << "Clearing atoms selection." << endl);
  World::getInstance().clearAtomSelection();
  return Action::state_ptr(new SelectionClearAllAtomsState(selectedAtoms, params));
}

Action::state_ptr SelectionClearAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionClearAllAtomsState *state = assert_cast<SelectionClearAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionClearAllAtomsAction::performRedo(Action::state_ptr _state){
  //SelectionClearAllAtomsState *state = assert_cast<SelectionClearAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();

  return Action::state_ptr(_state);
}

bool SelectionClearAllAtomsAction::canUndo() {
  return true;
}

bool SelectionClearAllAtomsAction::shouldUndo() {
  return true;
}

const string SelectionClearAllAtomsAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
