/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/AtomByIdAction.hpp"

// and construct the stuff
#include "AtomByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAtomByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  if (!World::getInstance().isSelected(params.Walker)) {
    DoLog(1) && (Log() << Verbose(1) << "Selecting atom " << *params.Walker << endl);
    World::getInstance().selectAtom(params.Walker);
    return Action::state_ptr(new SelectionAtomByIdState(params));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionAtomByIdAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByIdState *state = assert_cast<SelectionAtomByIdState*>(_state.get());

  if (state->params.Walker != NULL)
    World::getInstance().unselectAtom(state->params.Walker);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAtomByIdAction::performRedo(Action::state_ptr _state){
  SelectionAtomByIdState *state = assert_cast<SelectionAtomByIdState*>(_state.get());

  if (state->params.Walker != NULL)
    World::getInstance().selectAtom(state->params.Walker);

  return Action::state_ptr(_state);
}

bool SelectionAtomByIdAction::canUndo() {
  return true;
}

bool SelectionAtomByIdAction::shouldUndo() {
  return true;
}

const string SelectionAtomByIdAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
