/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomTypeDescriptor.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/AtomByElementAction.hpp"

// and construct the stuff
#include "AtomByElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAtomByElementAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting atoms of type " << *params.elemental << endl);
  World::getInstance().selectAllAtoms(AtomByType(params.elemental));
  return Action::state_ptr(new SelectionAtomByElementState(selectedAtoms,params));
}

Action::state_ptr SelectionAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByElementState *state = assert_cast<SelectionAtomByElementState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionAtomByElementState *state = assert_cast<SelectionAtomByElementState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByType(state->params.elemental));

  return Action::state_ptr(_state);
}

bool SelectionAtomByElementAction::canUndo() {
  return true;
}

bool SelectionAtomByElementAction::shouldUndo() {
  return true;
}

const string SelectionAtomByElementAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
