/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllMoleculesAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/AllMoleculesAction.hpp"

// and construct the stuff
#include "AllMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Selecting all molecules." << endl);
  World::getInstance().selectAllMolecules(AllMolecules());
  return Action::state_ptr(new SelectionAllMoleculesState(selectedMolecules,params));
}

Action::state_ptr SelectionAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionAllMoleculesState *state = assert_cast<SelectionAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllMoleculesAction::performRedo(Action::state_ptr _state){
  //SelectionAllMoleculesState *state = assert_cast<SelectionAllMoleculesState*>(_state.get());

  World::getInstance().selectAllMolecules(AllMolecules());

  return Action::state_ptr(_state);
}

bool SelectionAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionAllMoleculesAction::shouldUndo() {
  return true;
}

const string SelectionAllMoleculesAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
