/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllAtomsOfMoleculeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/AllAtomsOfMoleculeAction.hpp"

// and construct the stuff
#include "AllAtomsOfMoleculeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsOfMoleculeAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms of molecule " << params.mol->getName() << "." << endl);
  World::getInstance().selectAtomsOfMolecule(params.mol);
  return Action::state_ptr(new SelectionAllAtomsOfMoleculeState(selectedAtoms, params));
}

Action::state_ptr SelectionAllAtomsOfMoleculeAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsOfMoleculeState *state = assert_cast<SelectionAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsOfMoleculeAction::performRedo(Action::state_ptr _state){
  SelectionAllAtomsOfMoleculeState *state = assert_cast<SelectionAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().selectAtomsOfMolecule(state->params.mol);

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsOfMoleculeAction::canUndo() {
  return true;
}

bool SelectionAllAtomsOfMoleculeAction::shouldUndo() {
  return true;
}

const string SelectionAllAtomsOfMoleculeAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
