/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllAtomsInsideSphereAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomShapeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/AllAtomsInsideSphereAction.hpp"

// and construct the stuff
#include "AllAtomsInsideSphereAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsInsideSphereAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms inside a sphere at " << params.position << " with radius " << params.radius << "." << endl);
  Shape s = translate(resize(Sphere(),params.radius),params.position);
  World::getInstance().selectAllAtoms(AtomByShape(s));
  return Action::state_ptr(new SelectionAllAtomsInsideSphereState(selectedAtoms, params));
}

Action::state_ptr SelectionAllAtomsInsideSphereAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsInsideSphereState *state = assert_cast<SelectionAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsInsideSphereAction::performRedo(Action::state_ptr _state){
  SelectionAllAtomsInsideSphereState *state = assert_cast<SelectionAllAtomsInsideSphereState*>(_state.get());

  Shape s = translate(resize(Sphere(),state->params.radius),state->params.position);
  World::getInstance().selectAllAtoms(AtomByShape(s));

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsInsideSphereAction::canUndo() {
  return true;
}

bool SelectionAllAtomsInsideSphereAction::shouldUndo() {
  return true;
}

const string SelectionAllAtomsInsideSphereAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
