/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllAtomsInsideCuboidAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomShapeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Matrix.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/SelectionAction/AllAtomsInsideCuboidAction.hpp"

// and construct the stuff
#include "AllAtomsInsideCuboidAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsInsideCuboidAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  Matrix RotationMatrix;

  // obtain information
  getParametersfromValueStorage();

  RotationMatrix.rotation(params.Xangle, params.Yangle, params.Zangle);

  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms inside a rotated " << RotationMatrix << " cuboid at " << params.position << " and extension of " << params.extension << "." << endl);
  Shape s = translate(transform(stretch(Cuboid(),params.extension),RotationMatrix),params.position);
  World::getInstance().selectAllAtoms(AtomByShape(s));
  return Action::state_ptr(new SelectionAllAtomsInsideCuboidState(selectedAtoms, params));
}

Action::state_ptr SelectionAllAtomsInsideCuboidAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsInsideCuboidState *state = assert_cast<SelectionAllAtomsInsideCuboidState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsInsideCuboidAction::performRedo(Action::state_ptr _state){
  SelectionAllAtomsInsideCuboidState *state = assert_cast<SelectionAllAtomsInsideCuboidState*>(_state.get());
  Matrix RotationMatrix;

  RotationMatrix.rotation(state->params.Xangle, state->params.Yangle, state->params.Zangle);
  Shape s = translate(transform(stretch(Cuboid(),state->params.extension),RotationMatrix),state->params.position);
  World::getInstance().selectAllAtoms(AtomByShape(s));

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsInsideCuboidAction::canUndo() {
  return true;
}

bool SelectionAllAtomsInsideCuboidAction::shouldUndo() {
  return true;
}

const string SelectionAllAtomsInsideCuboidAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
