/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Parser/XyzParser.hpp"
#include "atom.hpp"
#include "molecule.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/ParserAction/SaveXyzAction.hpp"

// and construct the stuff
#include "SaveXyzAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSaveXyzAction::performCall() {
  XyzParser parser;

  // obtain information
  getParametersfromValueStorage();

  // store xyz file
  ofstream output;
  output.open(params.filename.c_str());
  if (!output.fail())
    parser.save(&output);
  output.close();
  return Action::failure;
}

Action::state_ptr ParserSaveXyzAction::performUndo(Action::state_ptr _state) {
//  ParserSaveXyzState *state = assert_cast<ParserSaveXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserSaveXyzState(state->mol,newName));
}

Action::state_ptr ParserSaveXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
//  // Undo and redo have to do the same for this action
//  return performUndo(_state);
}

bool ParserSaveXyzAction::canUndo() {
  return false;
}

bool ParserSaveXyzAction::shouldUndo() {
  return false;
}

const string ParserSaveXyzAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
