/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LoadXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "Parser/XyzParser.hpp"

#include <iostream>

using namespace std;

#include "Actions/ParserAction/LoadXyzAction.hpp"

// and construct the stuff
#include "LoadXyzAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserLoadXyzAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Parsing xyz file for new atoms." << endl);
  // parse xyz file
  ifstream input;
  input.open(params.filename.c_str());
  if (!input.fail()) {
    XyzParser parser; // briefly instantiate a parser which is removed at end of focus
    parser.load(&input);
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Could not open file " << params.filename << "." << endl);
  }
  input.close();
  return Action::success;
}

Action::state_ptr ParserLoadXyzAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserLoadXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserLoadXyzAction::canUndo() {
  return false;
}

bool ParserLoadXyzAction::shouldUndo() {
  return false;
}

const string ParserLoadXyzAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
