/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VerletIntegrationAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"

// and construct the stuff
#include "VerletIntegrationAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeVerletIntegrationAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Parsing forces file and Verlet integrating." << endl);
    // TODO: sollte besser stream nutzen, nicht filename direkt (es sei denn, ist prefix), besser fuer unit test
    char outputname[MAXSTRINGSIZE];
    strcpy(outputname, params.forcesfile.c_str());
    if (!mol->VerletForceIntegration(outputname, *(World::getInstance().getConfig()), 0))
      DoLog(2) && (Log() << Verbose(2) << "File " << params.forcesfile << " not found." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File " << params.forcesfile << " found and parsed." << endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeVerletIntegrationAction::performUndo(Action::state_ptr _state) {
//  MoleculeVerletIntegrationState *state = assert_cast<MoleculeVerletIntegrationState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeVerletIntegrationAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeVerletIntegrationAction::canUndo() {
  return false;
}

bool MoleculeVerletIntegrationAction::shouldUndo() {
  return false;
}

const string MoleculeVerletIntegrationAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
