/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveTemperatureAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/SaveTemperatureAction.hpp"

// and construct the stuff
#include "SaveTemperatureAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeSaveTemperatureAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Storing temperatures in " << params.temperaturefile << "." << endl);
    ofstream output;
    output.open(params.temperaturefile.c_str(), ios::trunc);
    if (output.fail() || !mol->OutputTemperatureFromTrajectories((ofstream * const) &output, 0, mol->MDSteps))
      DoLog(2) && (Log() << Verbose(2) << "File could not be written." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File stored." << endl);
    output.close();
  }
  return Action::success;
}

Action::state_ptr MoleculeSaveTemperatureAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveTemperatureState *state = assert_cast<MoleculeSaveTemperatureState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveTemperatureAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveTemperatureAction::canUndo() {
  return false;
}

bool MoleculeSaveTemperatureAction::shouldUndo() {
  return false;
}

const string MoleculeSaveTemperatureAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
