/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FillWithMoleculeAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"


#include <iostream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/FillWithMoleculeAction.hpp"

// and construct the stuff
#include "FillWithMoleculeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeFillWithMoleculeAction::performCall() {

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Filling Box with water molecules, lengths(" << params.lengths[0] << "," << params.lengths[1] << "," << params.lengths[2] << "), distances (" << params.distances[0] << "," << params.distances[1] << "," << params.distances[2] << "), MaxDistance " << params.MaxDistance << ", DoRotate " << params.DoRotate << "." << endl);
  // construct water molecule
  molecule *filler = World::getInstance().createMolecule();
  if (!filler->AddXYZFile(params.fillername)) {
    DoeLog(0) && (eLog()<< Verbose(0) << "Could not parse filler molecule from " << params.fillername << "." << endl);
  }
  filler->SetNameFromFilename(params.fillername.c_str());
  molecule *Filling = NULL;
//    atom *first = NULL, *second = NULL, *third = NULL;
//    first = World::getInstance().createAtom();
//    first->type = World::getInstance().getPeriode()->FindElement(1);
//    first->x = Vector(0.441, -0.143, 0.);
//    filler->AddAtom(first);
//    second = World::getInstance().createAtom();
//    second->type = World::getInstance().getPeriode()->FindElement(1);
//    second->x = Vector(-0.464, 1.137, 0.0);
//    filler->AddAtom(second);
//    third = World::getInstance().createAtom();
//    third->type = World::getInstance().getPeriode()->FindElement(8);
//    third->x = Vector(-0.464, 0.177, 0.);
//    filler->AddAtom(third);
//    filler->AddBond(first, third, 1);
//    filler->AddBond(second, third, 1);
  World::getInstance().getConfig()->BG->ConstructBondGraph(filler);
//    filler->SetNameFromFilename("water");
  // call routine
  double distance[NDIM];
  for (int i=0;i<NDIM;i++)
    distance[i] = params.distances[i];
  Filling = FillBoxWithMolecule(World::getInstance().getMolecules(), filler, *(World::getInstance().getConfig()), params.MaxDistance, distance, params.lengths[0], params.lengths[1], params.lengths[2], params.DoRotate);
  if (Filling != NULL) {
    Filling->ActiveFlag = false;
    World::getInstance().getMolecules()->insert(Filling);
  }
  for (molecule::iterator iter = filler->begin(); !filler->empty(); iter = filler->begin()) {
    atom *Walker = *iter;
    filler->erase(iter);
    World::getInstance().destroyAtom(Walker);
  }
  World::getInstance().destroyMolecule(filler);

  return Action::success;
}

Action::state_ptr MoleculeFillWithMoleculeAction::performUndo(Action::state_ptr _state) {
//  MoleculeFillWithMoleculeState *state = assert_cast<MoleculeFillWithMoleculeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeFillWithMoleculeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeFillWithMoleculeAction::canUndo() {
  return false;
}

bool MoleculeFillWithMoleculeAction::shouldUndo() {
  return false;
}

const string MoleculeFillWithMoleculeAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
