/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BondFileAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/BondFileAction.hpp"

// and construct the stuff
#include "BondFileAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeBondFileAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  if(World::getInstance().countSelectedMolecules() == 1) {
    mol = World::getInstance().beginMoleculeSelection()->second;
    DoLog(0) && (Log() << Verbose(0) << "Parsing bonds from " << params.bondfile << "." << endl);
    ifstream input(params.bondfile.c_str());
    mol->CreateAdjacencyListFromDbondFile(&input);
    input.close();
    return Action::success;
  } else
    return Action::failure;
}

Action::state_ptr MoleculeBondFileAction::performUndo(Action::state_ptr _state) {
//  MoleculeBondFileState *state = assert_cast<MoleculeBondFileState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeBondFileAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeBondFileAction::canUndo() {
  return false;
}

bool MoleculeBondFileAction::shouldUndo() {
  return false;
}

const string MoleculeBondFileAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
