/*
 * MethodAction.h
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

#ifndef METHODACTION_H_
#define METHODACTION_H_

#include <boost/function.hpp>
#include <string>

#include "Actions/Action.hpp"

/**
 * Wrapper class that allows the construction of Actions from any kind of Method
 */
class MethodAction : public Action
{
public:
  MethodAction(std::string _name,boost::function<void()> _executeMethod,bool _doRegister=true);
  virtual ~MethodAction();
  virtual bool canUndo();
  virtual bool shouldUndo();

protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);


  boost::function<void()> executeMethod; //!< this stores the method to be called
};

#endif /* METHODACTION_H_ */
