/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MethodAction.cpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>
#include <boost/function.hpp>
#include <string>

#include "Actions/MethodAction.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

MethodAction::MethodAction(string _name,boost::function<void()> _executeMethod,bool _doRegister) :
   Action(_name,_doRegister),
executeMethod(_executeMethod)
{
}

MethodAction::~MethodAction()
{}

void MethodAction::getParametersfromValueStorage()
{};

Dialog* MethodAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}


Action::state_ptr MethodAction::performCall() {
  executeMethod();
  // we don't have a state to save so we return Action::success
  return Action::success;
}

Action::state_ptr MethodAction::performUndo(Action::state_ptr) {
  ASSERT(0,"Cannot undo a MethodAction");
  return Action::success;
}

Action::state_ptr MethodAction::performRedo(Action::state_ptr){
  ASSERT(0,"Cannot redo a MethodAction");
  return Action::success;
}

bool MethodAction::canUndo() {
  return false;
}

bool MethodAction::shouldUndo(){
  return true;
}
