/*
 * MakroAction.hpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

#ifndef MAKROACTION_HPP_
#define MAKROACTION_HPP_

#include <string>

#include "Actions/Action.hpp"

class ActionSequence;

/**
 * Action to allow producing bigger Actions from sequences of small actions.
 *
 * Destruction of the Actions and the sequence is handled by this class.
 */
class MakroAction : public Action
{
public:
  MakroAction(std::string _name,ActionSequence* _actions,bool _doRegister=true);
  virtual ~MakroAction();

  bool canUndo();
  bool shouldUndo();

protected:
  virtual Dialog *fillDialog(Dialog *dialog);
private:
  virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  ActionSequence *actions;
};

#endif /* MAKROACTION_HPP_ */
